# NeuroConnect Therapy Centre Management System

![NeuroConnect Logo](assets/logo.jpeg)

A comprehensive offline therapy centre management system designed specifically for NeuroConnect Therapy Centre. This system provides complete management capabilities for staff, patients, schedules, expenses, stock, and reporting - all running offline for maximum security and reliability.

## 🎯 System Overview

**NeuroConnect Therapy Centre Management System** is a modern, web-based application that runs entirely offline, providing secure management of all therapy centre operations. The system features a beautiful teal, yellow, and orange design theme that reflects the professional yet welcoming nature of NeuroConnect.

## ✨ Key Features

### 🔐 **Authentication & Security**
- **Role-based access control** (Admin and User roles)
- **Secure session management**
- **Admin credentials**: `admin` / `admin123` (Full access)
- **User credentials**: `user` / `user123` (Limited access - no staff/payroll)

### 👥 **Staff Management**
- **Complete staff directory** with real NeuroConnect directors
- **Payroll management** with detailed salary tracking
- **Staff performance tracking**
- **Role-based permissions**

### 🧑‍⚕️ **Patient Management**
- **Comprehensive patient records**
- **Medical history tracking**
- **Therapy type assignments**
- **Progress monitoring**
- **Export capabilities**

### 📅 **Enhanced Therapy Schedule**
- **Visual schedule overview** with expandable details
- **Multiple therapy types**: Speech Therapy, Occupational Therapy, Play & Social Skills, Special Education, Deep Tissue Massage, Physiotherapy, Comprehensive Neurohabilitative Assessment, Paediatric Neurologist Consultation
- **Recurring session management**
- **Department categorization** with color-coded badges
- **Location/room tracking**
- **Detailed session notes**
- **Status tracking** (Upcoming/Completed)
- **Smart filtering** by therapy type, date range, and status

### 💰 **Financial Management**
- **Expense tracking** in Ksh (Kenyan Shillings)
- **Category-based organization**
- **Receipt management**
- **Budget monitoring**
- **Financial reporting**

### 📦 **Stock Control**
- **Inventory management**
- **Low stock alerts**
- **Supplier tracking**
- **Purchase order management**
- **Stock movement history**

### 📊 **Comprehensive Reporting**
- **Real-time analytics dashboard**
- **Financial reports**
- **Patient progress reports**
- **Staff performance metrics**
- **Export to PDF/Excel formats**
## 🚀 Quick Start

### **Option 1: Desktop Shortcut (Recommended)**
1. Double-click **"NeuroConnect Therapy Centre"** icon on your desktop
2. System launches automatically in your browser
3. Login with your credentials

### **Option 2: Manual Launch**
1. Double-click `NeuroConnect.bat` in the NEUROMANAGEMENT folder
2. System opens in app mode for best experience
3. Login screen appears automatically

### **Option 3: Direct Browser Access**
1. Open your web browser
2. Navigate to the NEUROMANAGEMENT folder
3. Double-click `login.html`
4. Enter your credentials

## 🖥️ Installation & Setup

### **Creating Desktop Shortcut**
```powershell
# Run this command in PowerShell (as Administrator)
cd "C:\Users\Admin\Desktop\NEUROMANAGEMENT"
.\CreateShortcut.ps1
```

This creates shortcuts on both:
- **Desktop** for quick access
- **Start Menu** for system integration

### **System Requirements**
- **Windows 10/11**
- **Modern web browser** (Chrome, Edge, Firefox)
- **No internet connection required** (fully offline)
- **Minimum 100MB disk space**

## 👨‍💼 User Accounts & Permissions

### **Administrator Account**
- **Username**: `admin`
- **Password**: `admin123`
- **Permissions**: Full system access including:
  - Staff management and payroll
  - All patient records
  - Financial data and reporting
  - System configuration
  - All therapy scheduling

### **Standard User Account**
- **Username**: `user`
- **Password**: `user123`
- **Permissions**: Limited access including:
  - Patient records (view/edit)
  - Therapy scheduling
  - Expense tracking
  - Stock management
  - Basic reporting
  - **Restricted from**: Staff management and payroll

## 🏥 NeuroConnect Leadership Team

The system includes profiles for the real NeuroConnect directors:

### **Board of Directors**
- **Ms. Teresia Wanjiku Wairimu** - *Chairperson*
- **Dr. Githuku Shongwe** - *Vice Chairperson*
- **Mr. Anthony Shikuku Barasa** - *Treasurer*
- **Dr. Wangari Waweru** - *Secretary*

### **Executive Team**
- **Dr. Githuku Shongwe** - *Director*
- **Dr. Gatumia Gatundu** - *Medical Director*
- **Ms. Teresia Wanjiku Wairimu** - *Operations Director*

### Getting Started
1. Open the application in your web browser
2. Navigate using the sidebar menu
## 🎨 Design Features

### **Color Scheme**
- **Primary Teal**: Professional healthcare appearance
- **Accent Yellow**: Warm, welcoming highlights
- **Accent Orange**: Energetic call-to-action elements
- **Clean Typography**: Professional Segoe UI font family

### **Responsive Design**
- **Desktop optimized**: Full feature access
- **Tablet friendly**: Touch-optimized interface
- **Mobile responsive**: Essential features available

## 📱 Module Details

### **Enhanced Schedule Management**
The therapy schedule module provides comprehensive session management:

#### **Visual Features**
- **Expandable details**: Click info button for complete session information
- **Color-coded departments**: Each therapy type has distinct visual styling
- **Status indicators**: Clear upcoming vs completed session markers
- **Recurring badges**: Visual indicators for ongoing treatment plans

#### **Functional Features**
- **Smart filtering**: Filter by therapy type, date range, or status
- **Recurring sessions**: Set up weekly, bi-weekly, or monthly sessions
- **Location tracking**: Specify therapy rooms and locations
- **Detailed notes**: Comprehensive session documentation
- **Duration management**: Flexible session timing (15-240 minutes)

#### **Available Therapy Types**
1. **Speech Therapy** - Communication and language development
2. **Occupational Therapy** - Daily living skills and motor development
3. **Play and Social Skills Therapy** - Social interaction and play skills
4. **Special Education** - Individualized learning support
5. **Deep Tissue Massage** - Therapeutic muscle treatment
6. **Physiotherapy** - Physical rehabilitation and movement
7. **Comprehensive Neurohabilitative Assessment** - Complete evaluation
8. **Paediatric Neurologist Consultation** - Specialized medical consultation

## 💾 Data Management

### **Local Storage**
- **Secure offline storage** using browser localStorage
- **Automatic data persistence**
- **No external database required**
- **Privacy-focused** - data never leaves your computer

### **Data Export**
- **PDF reports** for official documentation
- **Excel exports** for data analysis
- **Backup functionality** for data security

## 🔧 Technical Specifications

### **Technology Stack**
- **Frontend**: HTML5, CSS3, Vanilla JavaScript
- **Storage**: Browser localStorage
- **Icons**: Font Awesome 6
- **Design**: Custom responsive CSS framework
- **Architecture**: Modular JavaScript components

### **Browser Compatibility**
- ✅ **Google Chrome** (Recommended)
- ✅ **Microsoft Edge**
- ✅ **Mozilla Firefox**
- ✅ **Safari** (macOS)

### **Performance**
- **Instant loading** - no server dependencies
- **Offline operation** - works without internet
- **Lightweight** - minimal resource usage
- **Fast response** - local data processing

## 🛠️ Troubleshooting

### **Common Issues**

#### **Login Problems**
- Verify credentials: `admin`/`admin123` or `user`/`user123`
- Clear browser cache if login persists
- Ensure JavaScript is enabled

#### **Data Not Saving**
- Check browser localStorage permissions
- Ensure sufficient disk space
- Try different browser if issues persist

#### **Display Issues**
- Refresh browser (F5 or Ctrl+R)
- Check screen resolution compatibility
- Enable JavaScript in browser settings

### **Performance Tips**
- **Use Chrome or Edge** for best performance
- **Launch via batch file** for app mode experience
- **Regular browser cache clearing** for optimal speed

## 📞 Support & Contact

For technical support or system customization:

**NeuroConnect Therapy Centre**
- **Location**: Professional therapy services
- **System**: Offline management platform
- **Support**: Technical assistance available

## 🔄 Updates & Maintenance

### **Version History**
- **v1.0**: Initial system with basic modules
- **v1.1**: Enhanced authentication and role management
- **v1.2**: Improved schedule module with detailed views
- **v1.3**: Real director data integration
- **v1.4**: Enhanced UI/UX and responsive design
- **v2.0**: Comprehensive schedule overhaul with expandable details

### **Maintenance**
- **No updates required** - fully offline system
- **Backup recommendations**: Export data regularly
- **Browser updates**: Keep browser current for security

## 📄 License & Privacy

- **Private System**: Designed exclusively for NeuroConnect
- **Data Privacy**: All data remains on local computer
- **No External Communication**: Completely offline operation
- **Secure**: No cloud storage or external dependencies

---

**NeuroConnect Therapy Centre Management System** - *Professional healthcare management made simple*

*Offline. Secure. Comprehensive.*

This project is proprietary software developed for Neuroconnect Therapy Centre.

## Version

**Version 1.0** - Initial Release
- Complete feature set implementation
- Full offline functionality
- Comprehensive reporting system
- Mobile-responsive design

---

For technical support or feature requests, please contact the development team.
