@echo off
color 0B
title NeuroConnect Therapy Centre Management System v2.0
cls

echo.
echo  ================================================================================================
echo                    NeuroConnect Therapy Centre Management System v2.0
echo  ================================================================================================
echo.
echo   Starting your professional therapy management system...
echo.
echo   Features Available:
echo   - Enhanced Therapy Scheduling with expandable details
echo   - Role-based Authentication (Admin/User access)
echo   - Real NeuroConnect Directors Database
echo   - Comprehensive Patient and Staff Management
echo   - Financial Tracking in Ksh Currency
echo   - Stock Control and Inventory Management
echo   - Advanced Reporting and Analytics
echo.
echo  ================================================================================================
echo.

REM Check if running from correct directory
if not exist "login.html" (
    echo  ERROR: login.html not found in current directory!
    echo  Please ensure you're running this from the NEUROMANAGEMENT folder.
    echo.
    pause
    exit /b 1
)

echo   Launching NeuroConnect in optimized app mode...
echo.

REM Try Chrome first (best performance)
where chrome >nul 2>nul
if %ERRORLEVEL% EQU 0 (
    echo   [✓] Found Google Chrome - Launching in app mode for best experience...
    start "" "chrome" --app="file:///%~dp0login.html" --disable-web-security --user-data-dir="%~dp0chrome-data" --window-size=1400,900 --window-position=100,50
    goto :success
)

REM Try Edge second
where msedge >nul 2>nul
if %ERRORLEVEL% EQU 0 (
    echo   [✓] Found Microsoft Edge - Launching in app mode...
    start "" "msedge" --app="file:///%~dp0login.html" --disable-web-security --window-size=1400,900
    goto :success
)

REM Try Firefox third
where firefox >nul 2>nul
if %ERRORLEVEL% EQU 0 (
    echo   [✓] Found Firefox - Launching in browser...
    start "" "firefox" "file:///%~dp0login.html"
    goto :success
)

REM Fallback to default browser
echo   [i] Using default browser...
start "" "file:///%~dp0login.html"

:success
echo.
echo  ================================================================================================
echo   NeuroConnect is now loading in your browser!
echo.
echo   Login Credentials:
echo   - Administrator: admin / admin123 (Full access)
echo   - Staff User:   user / user123  (Limited access)
echo.
echo   System Features:
echo   ✓ Enhanced Therapy Scheduling    ✓ Patient Management
echo   ✓ Staff Directory & Payroll      ✓ Financial Tracking
echo   ✓ Stock Control                  ✓ Advanced Reports
echo   ✓ Real Directors Database        ✓ Offline Operation
echo.
echo   For technical support, please refer to README.md
echo  ================================================================================================
echo.

timeout /t 3 >nul
exit
